const formatters = {
  pretty: new Intl.DateTimeFormat('en-GB', { day: '2-digit', month: 'short', year: 'numeric' }),
};

function toDate(value) {
  if (!value) return null;
  if (value instanceof Date) return value;
  const parsed = new Date(value);
  return Number.isNaN(parsed.getTime()) ? null : parsed;
}

function formatPrettyDate(value) {
  const date = toDate(value);
  if (!date) return '—';
  return formatters.pretty.format(date);
}

function getLocalDateInfo() {
  const now = new Date();
  const isoDate = now.toISOString().slice(0, 10);
  return {
    isoDate,
    localDate: now,
    dayOfWeek: now.getDay(),
    dayOfMonth: now.getDate(),
    month: now.getMonth() + 1,
    year: now.getFullYear(),
  };
}

function normalizeSqlDate(value) {
  const date = toDate(value);
  if (!date) return null;
  return date.toISOString().slice(0, 10);
}

function derivePlanMonthYear(dateStr) {
  const date = toDate(dateStr);
  if (!date) {
    return { month: new Date().getUTCMonth() + 1, year: new Date().getUTCFullYear() };
  }
  return {
    month: date.getUTCMonth() + 1,
    year: date.getUTCFullYear(),
  };
}

module.exports = {
  formatPrettyDate,
  getLocalDateInfo,
  normalizeSqlDate,
  derivePlanMonthYear,
};
