const nodemailer = require('nodemailer');
const dotenv = require('dotenv');

dotenv.config();

const smtpConfig = {
  host: process.env.SMTP_HOST || 'smtp.gmail.com',
  port: Number(process.env.SMTP_PORT || 465),
  secure: process.env.SMTP_SECURE === 'false' ? false : true,
  auth: {
    user: process.env.SMTP_USER,
    pass: process.env.SMTP_PASS,
  },
};

const transporter = nodemailer.createTransport(smtpConfig);

const FROM = process.env.SMTP_FROM || 'ARU HR <no-reply@aru-hr.com>';

async function sendEmail({ to, subject, html, text }) {
  if (!to) return;
  await transporter.sendMail({
    from: FROM,
    to,
    subject,
    html,
    text: text || stripHtml(html),
  });
}

function stripHtml(html) {
  if (!html) return '';
  return html.replace(/<[^>]+>/g, ' ').replace(/\s+/g, ' ').trim();
}

function wrapEmail({ greeting, intro, details = [], status, actionUrl, outro }) {
  const detailRows = (details || [])
    .map(
      (item) => `
        <tr>
          <td style="padding:6px 10px;font-size:14px;color:#555;background:#fafafa;border:1px solid #eee;width:45%;font-weight:600;">
            ${item.label}
          </td>
          <td style="padding:6px 10px;font-size:14px;color:#333;border:1px solid #eee;">
            ${item.value ?? '—'}
          </td>
        </tr>`
    )
    .join('');

  const statusBadge = status
    ? `<div style="display:inline-block;padding:6px 12px;border-radius:999px;font-size:12px;font-weight:600;background:${status.color || '#1976D2'};color:#fff;margin:8px 0;">
        ${status.label}
      </div>`
    : '';

  const actionButton = actionUrl
    ? `<a href="${actionUrl}"
          style="display:inline-block;background:#1976D2;color:#fff;text-decoration:none;padding:12px 24px;border-radius:6px;font-weight:600;margin-top:16px;">
        View details
      </a>`
    : '';

  return `
    <div style="font-family:'Segoe UI',Arial,sans-serif;background:#f5f7fb;padding:32px;">
      <div style="max-width:620px;margin:0 auto;background:#fff;border-radius:16px;padding:32px;box-shadow:0 20px 60px rgba(15,23,42,0.08);">
        <h1 style="font-size:22px;margin:0 0 12px;color:#111;">${intro || 'Notification from ARU HR'}</h1>
        <p style="font-size:15px;color:#555;margin:0 0 16px;">${greeting || 'Hi there,'}</p>
        ${statusBadge}
        ${detailRows ? `<table style="width:100%;border-collapse:collapse;margin-top:16px;">${detailRows}</table>` : ''}
        ${actionButton}
        ${outro ? `<p style="font-size:14px;color:#666;margin-top:24px;">${outro}</p>` : ''}
        <p style="font-size:12px;color:#999;margin-top:32px;">This message was sent via the ARU HR system.</p>
      </div>
    </div>`;
}

async function sendLeaveEmail({ to, subject, greeting, intro, details, status, actionUrl, outro }) {
  await sendEmail({
    to,
    subject,
    html: wrapEmail({ greeting, intro, details, status, actionUrl, outro }),
  });
}

async function sendPlanEmail({ to, subject, greeting, intro, details, status, actionUrl, outro }) {
  await sendEmail({
    to,
    subject,
    html: wrapEmail({ greeting, intro, details, status, actionUrl, outro }),
  });
}

async function sendNotificationEmail({ to, subject, greeting, intro, details, status, actionUrl, outro }) {
  await sendEmail({
    to,
    subject,
    html: wrapEmail({ greeting, intro, details, status, actionUrl, outro }),
  });
}

module.exports = {
  sendEmail,
  sendLeaveEmail,
  sendPlanEmail,
  sendNotificationEmail,
};
